import { API_ENDPOINTS } from "@/lib/apiEndpoints";
import { Metadata } from "next";
import SolvedCategoryClient from "./SolvedCategoryClient";
import { buildAssignmentCourseMeta } from "@/lib/seo/assignmentMeta";

export const dynamic = "force-dynamic";

async function fetchCourseData(courseCode: string) {
    try {
        const res = await API_ENDPOINTS.ASSIGNMENTS.COURSE_DETAIL("solved", courseCode);
        if (!res.ok) throw new Error(`HTTP ${res.status}`);
        const data = await res.json();
        return {
            course: data.course,
            list: data.list || []
        };
    } catch (err: any) {
        console.error("❌ Failed to load solved course details", err);
        return null;
    }
}

export async function generateMetadata({ params }: { params: Promise<{ slug: string }> }): Promise<Metadata> {
    const resolvedParams = await params;
    const data = await fetchCourseData(resolvedParams.slug);
    if (!data || !data.course) return { title: "Course Assignments" };

    const meta = buildAssignmentCourseMeta(data.course);
    return {
        ...meta,
        alternates: {
            canonical: `/assignments/solved/${resolvedParams.slug}`,
        }
    };
}

export default async function SubjectDetails({ params }: { params: Promise<{ slug: string }> }) {
    const resolvedParams = await params;
    const data = await fetchCourseData(resolvedParams.slug);

    if (!data) {
        return <div className="text-danger text-center py-5">Failed to load course details.</div>;
    }

    return (
        <SolvedCategoryClient
            courseData={data.course}
            assignmentsList={data.list}
            courseCode={resolvedParams.slug}
        />
    );
}